<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cart_id = $_POST['cart_id'] ?? '';
    if ($cart_id) {
        $stmt = $conn->prepare("DELETE FROM cart WHERE cart_id=?");
        $stmt->bind_param("i", $cart_id);
        $stmt->execute();
        $message = "Cart item deleted.";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Delete Cart Item</title></head>
<body>
<h2>Delete Cart Item</h2>
<?php if (isset($message)) echo "<p>$message</p>"; ?>
<form method="POST">
    Cart ID: <input type="number" name="cart_id" required><br><br>
    <input type="submit" value="Delete Item">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
