<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $cart_id = $_POST['cart_id'] ?? '';
    $customer_id = $_POST['customer_id'] ?? '';
    $product_id = $_POST['product_id'] ?? '';
    $quantity = $_POST['quantity'] ?? '';

    if ($cart_id && $customer_id && $product_id && $quantity) {
        $stmt = $conn->prepare("UPDATE cart SET customer_id=?, product_id=?, quantity=? WHERE cart_id=?");
        $stmt->bind_param("iiii", $customer_id, $product_id, $quantity, $cart_id);
        $stmt->execute();
        $message = "Cart item updated.";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Update Cart Item</title></head>
<body>
<h2>Update Cart Item</h2>
<?php if (isset($message)) echo "<p>$message</p>"; ?>
<form method="POST">
    Cart ID: <input type="number" name="cart_id" required><br><br>
    Customer ID: <input type="number" name="customer_id" required><br><br>
    Product ID: <input type="number" name="product_id" required><br><br>
    Quantity: <input type="number" name="quantity" required><br><br>
    <input type="submit" value="Update Item">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
