<?php
// Enable error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

// Make sure db.php path is correct
require("db.php"); // if db.php is in the same folder

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $first_name = trim($_POST['first_name'] ?? '');
    $last_name = trim($_POST['last_name'] ?? '');
    $email = trim($_POST['email'] ?? '');

    if ($first_name && $last_name && $email) {
        // Check if prepare works
        $stmt = $conn->prepare("INSERT INTO customers (first_name, last_name, email) VALUES (?, ?, ?)");
        if (!$stmt) {
            die("Prepare failed: " . $conn->error);
        }

        $stmt->bind_param("sss", $first_name, $last_name, $email);

        if ($stmt->execute()) {
            $message = "Customer added successfully.";
        } else {
            $message = "Execute failed: " . $stmt->error;
        }
        $stmt->close();
    } else {
        $message = "All fields are required.";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Add Customer</title></head>
<body>
<h2>Add Customer</h2>
<?php if ($message) echo "<p>$message</p>"; ?>
<form method="POST">
    First Name: <input type="text" name="first_name" required><br><br>
    Last Name: <input type="text" name="last_name" required><br><br>
    Email: <input type="email" name="email" required><br><br>
    <input type="submit" value="Add Customer">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
