<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    if ($id) {
        $stmt = $conn->prepare("DELETE FROM customers WHERE customer_id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $message = "Customer deleted.";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Delete Customer</title></head>
<body>
<h2>Delete Customer</h2>
<?php if (isset($message)) echo "<p>$message</p>"; ?>
<form method="POST">
    Customer ID: <input type="number" name="id" required><br><br>
    <input type="submit" value="Delete Customer">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
