<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

session_start();

// Adjust path to db.php
require("db.php");  

if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Initialize attempts
if (!isset($_SESSION['attempts'])) {
    $_SESSION['attempts'] = 0;
}

$username = $_POST['username'] ?? '';
$password = $_POST['password'] ?? '';

if (!empty($username) && !empty($password)) {

    $sql = "SELECT * FROM admin_table WHERE adm_username=?";
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($row = $result->fetch_assoc()) {
        if (password_verify($password, $row['adm_password'])) {
            $_SESSION['attempts'] = 0;
            $_SESSION['logged_in'] = true;
            header("Location: home.php");
            exit();
        } else {
            $_SESSION['attempts']++;
        }
    } else {
        $_SESSION['attempts']++;
    }
}

// Handle failed login
if ($_SESSION['attempts'] >= 3) {
    $_SESSION['login_error'] = "Too many failed attempts. Access denied.";
} else {
    $_SESSION['login_error'] = "Invalid login. Attempts used: " . $_SESSION['attempts'] . " / 3";
}

header("Location: index.php");
exit();
