<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    if ($id) {
        $stmt = $conn->prepare("DELETE FROM products WHERE product_id=?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $message = "Product deleted.";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Delete Product</title></head>
<body>
<h2>Delete Product</h2>
<?php if (isset($message)) echo "<p>$message</p>"; ?>
<form method="POST">
    Product ID: <input type="number" name="id" required><br><br>
    <input type="submit" value="Delete Product">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
