<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    $name = $_POST['name'] ?? '';
    $price = $_POST['price'] ?? '';

    if ($id && $name && $price) {
        $stmt = $conn->prepare("UPDATE products SET product_name=?, price=? WHERE product_id=?");
        $stmt->bind_param("sdi", $name, $price, $id);
        $stmt->execute();
        $message = "Product updated.";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Update Product</title></head>
<body>
<h2>Update Product</h2>
<?php if (isset($message)) echo "<p>$message</p>"; ?>
<form method="POST">
    Product ID: <input type="number" name="id" required><br><br>
    Name: <input type="text" name="name" required><br><br>
    Price: <input type="number" step="0.01" name="price" required><br><br>
    <input type="submit" value="Update Product">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
