<?php
session_start();

if (!isset($_SESSION['cart']) || empty($_SESSION['cart'])) {
    echo "<p>Your cart is empty.</p>";
    echo "<a href='multi_product.php'>Go back to products</a>";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Guest Checkout</title>
<link rel="stylesheet" href="style.css">
<style>
    form { max-width: 500px; margin: 0 auto; text-align: left; }
    label { display: block; margin-top: 10px; font-weight: bold; }
    input, select, textarea { width: 100%; padding: 8px; margin-top: 4px; }
    .btn { margin-top: 20px; padding: 10px 20px; background-color: #0077cc; color: #fff; border: none; border-radius: 4px; cursor: pointer; }
    .btn:hover { background-color: #005fa3; }
</style>
</head>
<body>
<?php include("nav.php"); ?>

<main>
<h2 style="text-align:center;">Guest Checkout</h2>

<form method="POST" action="guest_order_confirm.php">
    <label>Full Name:</label>
    <input type="text" name="full_name" required>

    <label>Email:</label>
    <input type="email" name="email" required>

    <label>Country:</label>
    <select name="country" id="country" required onchange="updateStateField()">
        <option value="">Select Country</option>
        <option value="US">United States</option>
        <option value="Canada">Canada</option>
        <option value="UK">United Kingdom</option>
        <option value="Australia">Australia</option>
        <option value="Other">Other</option>
    </select>

    <label>State / Province:</label>
    <select name="state" id="state-select" style="display:none;"></select>
    <input type="text" name="state_other" id="state-other" placeholder="Enter state/province" style="display:none;">

    <label>City:</label>
    <input type="text" name="city" required>

    <label>ZIP / Postal Code:</label>
    <input type="text" name="zip" pattern="[0-9]{5}" placeholder="e.g. 12345" required>

    <label>Street Address:</label>
    <textarea name="address" required></textarea>

    <button type="submit" class="btn">Place Order</button>
</form>
</main>

<script>
const usStates = ["AL","AK","AZ","AR","CA","CO","CT","DE","FL","GA","HI","ID","IL","IN","IA","KS","KY","LA","ME","MD","MA","MI","MN","MS","MO","MT","NE","NV","NH","NJ","NM","NY","NC","ND","OH","OK","OR","PA","RI","SC","SD","TN","TX","UT","VT","VA","WA","WV","WI","WY"];

function updateStateField() {
    const country = document.getElementById("country").value;
    const stateSelect = document.getElementById("state-select");
    const stateOther = document.getElementById("state-other");

    if (country === "US") {
        stateSelect.style.display = "block";
        stateOther.style.display = "none";
        stateSelect.innerHTML = "<option value=''>Select State</option>";
        usStates.forEach(st => stateSelect.innerHTML += `<option value="${st}">${st}</option>`);
    } else if (country === "Canada") {
        stateSelect.style.display = "block";
        stateOther.style.display = "none";
        const provinces = ["AB","BC","MB","NB","NL","NS","ON","PE","QC","SK","NT","NU","YT"];
        stateSelect.innerHTML = "<option value=''>Select Province</option>";
        provinces.forEach(pr => stateSelect.innerHTML += `<option value="${pr}">${pr}</option>`);
    } else {
        stateSelect.style.display = "none";
        stateOther.style.display = "block";
    }
}
</script>
</body>
</html>
