<?php 
session_start();
require("db.php");  // include your database connection

// Fetch products from the database
$products = [];
$sql = "SELECT product_id, product_name, price FROM products";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $products[$row['product_id']] = [
            "name" => $row['product_name'],
            "price" => $row['price'],
            "image" => "multi_images/lure" . $row['product_id'] . ".jpg"
        ];
    }

    // Pick a random product for featured lure
    $featured_id = array_rand($products);
    $featured_product = $products[$featured_id];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Fishing Lures - Home</title>
  <link rel="stylesheet" href="style.css">
  <style>
    .feature {
        text-align: center;
        margin: 40px 0;
    }
    .feature img {
        border-radius: 8px;
        max-width: 100%;
        height: auto;
    }
    .feature button {
        margin-top: 12px;
        padding: 10px 20px;
        background-color: #0077cc;
        color: #fff;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }
    .feature button:hover {
        background-color: #005fa3;
    }
  </style>
</head>
<body>
<?php include("nav.php"); ?>

<main>
    <section class="feature">
      <h2>Featured Lure of the Week</h2>
      <a href="single_product.php?id=<?php echo $featured_id; ?>">
        <img src="<?php echo $featured_product['image']; ?>" 
             alt="<?php echo htmlspecialchars($featured_product['name']); ?>" width="300">
      </a>
      <p>This week’s spotlight: the <em><?php echo htmlspecialchars($featured_product['name']); ?></em>!</p>
      <button onclick="window.location.href='single_product.php?id=<?php echo $featured_id; ?>'">Shop Now</button>
    </section>
</main>

<footer>
    <p>&copy; 2025 Fishing Lures Co.</p>
</footer>
</body>
</html>
