<?php
// nav.php - include this at top of each user page (after any session_start if needed)
if (session_status() === PHP_SESSION_NONE) session_start();
require_once("db.php");

// fetch products for dropdown
$products = [];
$res = $conn->query("SELECT product_id, product_name FROM products");
if ($res) {
    while ($r = $res->fetch_assoc()) {
        $products[$r['product_id']] = $r['product_name'];
    }
}
?>
<header>
  <h1>Fishing Lures</h1>
  <nav class="main-nav">
    <a href="index.php">Home</a>
    <a href="multi_product.php">See All Lures</a>

    <div class="dropdown">
      <button class="dropbtn">Single Products ▾</button>
      <div class="dropdown-content">
        <?php foreach ($products as $pid => $name): ?>
          <a href="single_product.php?id=<?php echo (int)$pid; ?>"><?php echo htmlspecialchars($name); ?></a>
        <?php endforeach; ?>
      </div>
    </div>

    <a href="checkout.php">Checkout</a>
    <a href="../LP3_admin/" style="background-color: #f00;">Admin Home</a>

    <?php if (!empty($_SESSION['customer_name'])): ?>
      <span style="margin-left:20px; font-weight:bold;">Welcome, <?php echo htmlspecialchars($_SESSION['customer_name']); ?>!</span>
      <a href="logout.php" style="margin-left:10px; color:red;">Logout</a>
    <?php else: ?>
      <a href="login.php" style="margin-left:20px;">Login</a>
    <?php endif; ?>

  </nav>
</header>
