<?php
session_start();
require("db.php");

// Get product ID from URL
$product_id = $_GET['id'] ?? 0;
$product_id = (int)$product_id;

// Fetch product from database
$stmt = $conn->prepare("SELECT * FROM products WHERE product_id=?");
$stmt->bind_param("i", $product_id);
$stmt->execute();
$result = $stmt->get_result();
$product = $result->fetch_assoc();

if (!$product) {
    echo "Product not found.";
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title><?php echo htmlspecialchars($product['product_name']); ?> - Fishing Lures</title>
<link rel="stylesheet" href="style.css">
<style>
/* Your existing styles for centering, product, buttons, etc. */
body {
    font-family: Arial, sans-serif;
    background-color: #f9f9f9;
    margin: 0;
    padding: 0;
}

/* Center the product */
.product-container {
    display: flex;
    justify-content: center; /* centers horizontally */
    padding: 30px 20px;
}

.product {
    max-width: 400px;
    text-align: center;
    background: white;
    border: 1px solid #ccc;
    padding: 20px;
    border-radius: 6px;
    box-shadow: 2px 2px 8px #eee;
}

.product img {
    width: 100%;
    height: auto;
    border-radius: 4px;
}

.product h2 {
    margin: 15px 0 10px 0;
    font-size: 22px;
}

.product p {
    margin: 8px 0;
    font-size: 16px;
}

.product form {
    margin-top: 15px;
}

.product input[type="number"] {
    width: 60px;
    padding: 4px;
    margin-right: 10px;
}

.product button {
    padding: 8px 16px;
    background-color: #0077cc;
    color: white;
    border: none;
    border-radius: 4px;
    cursor: pointer;
}

.product button:hover {
    background-color: #005fa3;
}

footer {
    text-align: center;
    padding: 15px;
    background-color: #f2f2f2;
    margin-top: 30px;
}
</style>
</head>
<body>

<?php include("nav.php"); ?>

<main>
    <div class="product-container">
        <div class="product">
            <img src="single_images/lure<?php echo $product['product_id']; ?>.jpg" 
                 alt="<?php echo htmlspecialchars($product['product_name']); ?>">

            <h2><?php echo htmlspecialchars($product['product_name']); ?></h2>
            <p><strong>Price:</strong> $<?php echo number_format($product['price'],2); ?></p>
            <p><strong>In Stock:</strong> <?php echo (int)$product['quantity']; ?></p>

            <form action="add_to_cart.php" method="POST">
                <input type="hidden" name="product_id" value="<?php echo $product['product_id']; ?>">
                <label>Qty:</label>
                <input type="number" name="quantity" min="1" value="1">
                <button type="submit">Add to Cart</button>
            </form>
        </div>
    </div>
</main>

<footer>
    <p>&copy; 2025 Fishing Lures Co.</p>
</footer>
</body>
</html>
