<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $customer_id = $_POST['customer_id'] ?? '';
    $product_id = $_POST['product_id'] ?? '';
    $quantity = $_POST['quantity'] ?? '';

    if ($customer_id && $product_id && $quantity) {
        $stmt = $conn->prepare("INSERT INTO cart (customer_id, product_id, quantity) VALUES (?, ?, ?)");
        $stmt->bind_param("iii", $customer_id, $product_id, $quantity);
        if ($stmt->execute()) {
            $message = "Cart item added successfully.";
        } else {
            $message = "Error: " . $stmt->error;
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Add Cart Item</title></head>
<body>
<h2>Add Cart Item</h2>
<?php if (isset($message)) echo "<p>$message</p>"; ?>
<form method="POST">
    Customer ID: <input type="number" name="customer_id" required><br><br>
    Product ID: <input type="number" name="product_id" required><br><br>
    Quantity: <input type="number" name="quantity" required><br><br>
    <input type="submit" value="Add Item">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
