<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

$result = $conn->query("
    SELECT c.cart_id, cu.first_name, cu.last_name, p.product_name, c.quantity
    FROM cart c
    JOIN customers cu ON c.customer_id = cu.customer_id
    JOIN products p ON c.product_id = p.product_id
");
?>
<!DOCTYPE html>
<html>
<head><title>Cart Report</title></head>
<body>
<h2>Cart Report</h2>
<table border="1">
<tr>
    <th>Cart ID</th>
    <th>Customer</th>
    <th>Product</th>
    <th>Quantity</th>
</tr>
<?php while($row = $result->fetch_assoc()): ?>
<tr>
    <td><?= $row['cart_id'] ?></td>
    <td><?= $row['first_name'] . ' ' . $row['last_name'] ?></td>
    <td><?= $row['product_name'] ?></td>
    <td><?= $row['quantity'] ?></td>
</tr>
<?php endwhile; ?>
</table>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
