<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? '';
    $first_name = $_POST['first_name'] ?? '';
    $last_name = $_POST['last_name'] ?? '';
    $email = $_POST['email'] ?? '';

    if ($id && $first_name && $last_name && $email) {
        $stmt = $conn->prepare("UPDATE customers SET first_name=?, last_name=?, email=? WHERE customer_id=?");
        $stmt->bind_param("sssi", $first_name, $last_name, $email, $id);
        $stmt->execute();
        $message = "Customer updated.";
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Update Customer</title></head>
<body>
<h2>Update Customer</h2>
<?php if (isset($message)) echo "<p>$message</p>"; ?>
<form method="POST">
    Customer ID: <input type="number" name="id" required><br><br>
    First Name: <input type="text" name="first_name" required><br><br>
    Last Name: <input type="text" name="last_name" required><br><br>
    Email: <input type="email" name="email" required><br><br>
    <input type="submit" value="Update Customer">
</form>
<a href="home.php">Back to Dashboard</a>
</body>
</html>
