<?php
session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

require("db.php"); // database connection

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $name = $_POST['name'] ?? '';
    $price = $_POST['price'] ?? '';
    $quantity = $_POST['quantity'] ?? '';

    if ($name && $price && $quantity !== '') {
        $stmt = $conn->prepare("INSERT INTO products (product_name, price, quantity) VALUES (?, ?, ?)");
        $stmt->bind_param("sdi", $name, $price, $quantity);

        if ($stmt->execute()) {
            $message = "Product added successfully.";
        } else {
            $message = "Error: " . $stmt->error;
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head><title>Add Product</title></head>
<body>

<h2>Add Product</h2>

<?php if (isset($message)) echo "<p>$message</p>"; ?>

<form method="POST">
    Name: <input type="text" name="name" required><br><br>

    Price: <input type="number" step="0.01" name="price" required><br><br>

    Quantity: <input type="number" name="quantity" required><br><br>

    <input type="submit" value="Add Product">
</form>

<a href="home.php">Back to Dashboard</a>

</body>
</html>
