<?php
session_start();
require("db.php");

$product_id = (int)($_POST['product_id'] ?? 0);
$quantity = (int)($_POST['quantity'] ?? 1);

if ($product_id <= 0) {
    die("Invalid product ID. <a href='multi_product.php'>Go Back</a>");
}

// Fetch product from database
$stmt = $conn->prepare("SELECT product_name, price FROM products WHERE product_id = ?");
$stmt->bind_param("i", $product_id);
$stmt->execute();
$stmt->bind_result($product_name, $price);
$stmt->fetch();
$stmt->close();

if (!$product_name) {
    die("PRODUCT NOT FOUND. <a href='multi_product.php'>Go Back</a>");
}

// Add to session cart
if (!isset($_SESSION['cart'])) $_SESSION['cart'] = [];

if (isset($_SESSION['cart'][$product_id])) {
    $_SESSION['cart'][$product_id]['quantity'] += $quantity;
} else {
    $_SESSION['cart'][$product_id] = [
        'id' => $product_id,
        'name' => $product_name,
        'price' => $price,
        'quantity' => $quantity
    ];
}

header("Location: checkout.php");
exit();
