<?php
session_start();
require("db.php"); // Make sure your DB connection works

// Initialize cart if it doesn't exist
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Handle updates
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update'])) {
    foreach ($_POST['quantities'] as $cart_key => $qty) {
        $qty = (int)$qty;
        if (isset($_SESSION['cart'][$cart_key])) {
            $_SESSION['cart'][$cart_key]['quantity'] = $qty;
        }
    }

    // Remove items checked for deletion
    if (isset($_POST['remove'])) {
        foreach ($_POST['remove'] as $cart_key => $val) {
            unset($_SESSION['cart'][$cart_key]);
        }
    }

    // Redirect to avoid form resubmission
    header("Location: checkout.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Shopping Cart</title>
<link rel="stylesheet" href="style.css">
<style>
    body { font-family: Arial, sans-serif; margin: 0; padding: 0; background: #f9f9f9; }
    main { max-width: 900px; margin: 20px auto; padding: 20px; background: white; border-radius: 6px; box-shadow: 2px 2px 8px #ccc; }
    h2 { text-align: center; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { padding: 10px; border: 1px solid #ccc; text-align: center; }
    img { width: 80px; }
    input[type="number"] { width: 60px; padding: 4px; }
    input[type="checkbox"] { transform: scale(1.3); }
    .btn { display: inline-block; margin: 6px; padding: 8px 14px; background-color: #0077cc; color: white; text-decoration: none; border-radius: 4px; cursor: pointer; }
    .btn:hover { background-color: #005fa3; }
    .empty-cart { text-align: center; padding: 40px; font-size: 1.2em; color: #555; }
</style>
</head>
<body>
<?php include("nav.php"); ?>

<main>
<h2>Your Shopping Cart</h2>

<?php if (empty($_SESSION['cart'])): ?>
    <div class="empty-cart">
        <p>Your cart is currently empty.</p>
        <a href="multi_product.php" class="btn">Go back to Products</a>
    </div>
<?php else: ?>
    <form method="POST" action="checkout.php">
    <table>
        <tr>
            <th>Remove</th>
            <th>Product</th>
            <th>Image</th>
            <th>Price</th>
            <th>Quantity</th>
            <th>Total</th>
        </tr>
        <?php
        $totalPrice = 0;
        foreach ($_SESSION['cart'] as $id => $item):
            $lineTotal = $item['price'] * $item['quantity'];
            $totalPrice += $lineTotal;
            $img = "multi_images/lure" . $item['id'] . ".jpg";
            if (!file_exists($img)) $img = "images/placeholder.png";
        ?>
        <tr>
            <td>
                <input type="checkbox" name="remove[<?php echo $id; ?>]">
            </td>
            <td><?php echo htmlspecialchars($item['name']); ?></td>
            <td><img src="<?php echo $img; ?>" alt="<?php echo htmlspecialchars($item['name']); ?>"></td>
            <td>$<?php echo number_format($item['price'], 2); ?></td>
            <td>
                <input type="number" name="quantities[<?php echo $id; ?>]" value="<?php echo $item['quantity']; ?>" min="1">
            </td>
            <td>$<?php echo number_format($lineTotal, 2); ?></td>
        </tr>
        <?php endforeach; ?>
        <tr>
            <td colspan="5"><strong>Grand Total</strong></td>
            <td><strong>$<?php echo number_format($totalPrice, 2); ?></strong></td>
        </tr>
    </table>

    <button type="submit" name="update" class="btn">Update Cart</button>
    </form>

    <h3>Checkout Options</h3>
    <a href="login.php?from=cart" class="btn">Login as Registered User</a>
    <a href="register.php?from=cart" class="btn">Register as New User</a>
    <a href="guest_checkout.php" class="btn">Checkout as Guest</a>
    <br><br>
    <a href="multi_product.php" class="btn">Continue Shopping</a>
<?php endif; ?>

</main>
</body>
</html>
