<?php
session_start();
require("db.php");

// Check if cart exists
if (!isset($_SESSION['cart']) || empty($_SESSION['cart'])) {
    echo "<p>Your cart is empty.</p>";
    echo "<a href='multi_product.php'>Go back to products</a>";
    exit();
}

// Copy cart before clearing
$cart_items = $_SESSION['cart'];

// Get guest info
$full_name = htmlspecialchars($_POST['full_name'] ?? '');
$email = htmlspecialchars($_POST['email'] ?? '');
$country = htmlspecialchars($_POST['country'] ?? '');
$state = htmlspecialchars($_POST['state'] ?? $_POST['state_other'] ?? '');
$city = htmlspecialchars($_POST['city'] ?? '');
$zip = htmlspecialchars($_POST['zip'] ?? '');
$address = htmlspecialchars($_POST['address'] ?? '');

// Generate unique order number
$order_number = 'G' . time();
$total_price = 0;

// Insert each item into cart table
foreach ($cart_items as $item) {
    $product_id = (int)$item['id'];
    $quantity = (int)$item['quantity'];
    $price = (float)$item['price'];
    $line_total = $price * $quantity;

    $stmt = $conn->prepare("INSERT INTO cart (order_number, customer_number, product_id, quantity, price, total) VALUES (?, 99, ?, ?, ?, ?)");
    if ($stmt === false) {
        die("Prepare failed: " . $conn->error);
    }

    $stmt->bind_param("siidd", $order_number, $product_id, $quantity, $price, $line_total);
    if (!$stmt->execute()) {
        die("Execute failed: " . $stmt->error);
    }

    $total_price += $line_total;
}

// Clear session cart
unset($_SESSION['cart']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Order Confirmation</title>
<link rel="stylesheet" href="style.css">
<style>
body { max-width:800px; margin:0 auto; padding:20px; }
table { width:100%; border-collapse:collapse; margin-top:20px; }
th, td { border:1px solid #ccc; padding:8px; text-align:center; }
img { width:80px; }
h2, h3 { text-align:center; }
.btn { padding:6px 12px; background-color:#0077cc; color:#fff; text-decoration:none; border-radius:4px; }
.btn:hover { background-color:#005fa3; }
</style>
</head>
<body>
<?php include("nav.php"); ?>

<h2>Thank you for your order!</h2>
<p style="text-align:center;">Order Number: <strong><?php echo $order_number; ?></strong></p>

<h3>Shipping Information</h3>
<p>
<strong>Name:</strong> <?php echo $full_name; ?><br>
<strong>Email:</strong> <?php echo $email; ?><br>
<strong>Address:</strong> <?php echo $address; ?>, <?php echo $city; ?>, <?php echo $state; ?>, <?php echo $country; ?>, <?php echo $zip; ?>
</p>

<h3>Products Ordered</h3>
<table>
<tr>
<th>Product</th>
<th>Image</th>
<th>Price</th>
<th>Quantity</th>
<th>Total</th>
</tr>
<?php foreach ($cart_items as $item):
    $line_total = $item['price'] * $item['quantity'];
    $img = "multi_images/lure" . $item['id'] . ".jpg";
    if (!file_exists($img)) $img = "images/placeholder.png";
?>
<tr>
<td><?php echo htmlspecialchars($item['name']); ?></td>
<td><img src="<?php echo $img; ?>" alt="<?php echo htmlspecialchars($item['name']); ?>"></td>
<td>$<?php echo number_format($item['price'],2); ?></td>
<td><?php echo $item['quantity']; ?></td>
<td>$<?php echo number_format($line_total,2); ?></td>
</tr>
<?php endforeach; ?>
<tr>
<td colspan="4"><strong>Grand Total</strong></td>
<td><strong>$<?php echo number_format($total_price,2); ?></strong></td>
</tr>
</table>

<p style="text-align:center; margin-top:20px;">
<a href="multi_product.php" class="btn">Continue Shopping</a>
</p>
</body>
</html>
