<?php
session_start();
require("db.php"); // Make sure db.php exists and connects

$error = '';

// Only process form on POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    if (!$username || !$password) {
        $error = "Both fields are required.";
    } else {
        // Check credentials
        $stmt = $conn->prepare("SELECT customer_id, first_name, last_name, password FROM customer WHERE username=?");
        if (!$stmt) {
            die("Prepare failed: " . $conn->error); // Debug if preparation fails
        }
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();

        if ($user && password_verify($password, $user['password'])) {
            // Login successful
            $_SESSION['customer_id'] = $user['customer_id'];

            // Store full name in session for nav
            $_SESSION['customer_name'] = $user['first_name'] . ' ' . $user['last_name'];

            // Safe redirect
            $redirect = 'checkout.php'; // redirect to checkout or another page
            header("Location: $redirect");
            exit();
        } else {
            $error = "Invalid username or password.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Login</title>
<link rel="stylesheet" href="style.css">
</head>
<body>
<?php include("nav.php"); ?>

<main>
<h2>Login</h2>

<?php if (!empty($error)) echo "<p style='color:red;'>$error</p>"; ?>

<form method="POST" action="">
    <label>Username:</label>
    <input type="text" name="username" required>

    <label>Password:</label>
    <input type="password" name="password" required>

    <button type="submit" class="btn">Login</button>
</form>

<p>Don't have an account? <a href="register.php">Register here</a>.</p>
</main>
</body>
</html>
