<?php
session_start();
require("db.php"); // Needed for nav.php and product data
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>All Lures</title>
    <link rel="stylesheet" href="style.css">
    <style>
        .product-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
        }
        .product {
            border: 1px solid #ccc;
            padding: 12px;
            width: 420px;
            text-align: center;
            border-radius: 6px;
            box-shadow: 2px 2px 6px #eee;
        }
        .product img {
            width: 100%;
            max-width: 600px; 
            height: auto;
        }

        .btn {
            display: inline-block;
            margin-top: 6px;
            padding: 6px 12px;
            background-color: #0077cc;
            color: #fff;
            text-decoration: none;
            border-radius: 4px;
        }
        .btn:hover {
            background-color: #005fa3;
        }
        .small-desc {
            font-size: 0.9em;
            color: #333;
            margin: 6px 0;
        }
    </style>
</head>
<body>
<?php include("nav.php"); ?>

<main>
    <h2>All Products</h2>
    <div class="product-grid">

        <div class="product">
            <a href="single_product.php?id=1">
                <img src="multi_images/lure1.jpg" alt="Spinnerbait">
            </a>
            <h3><a href="single_product.php?id=1">Spinnerbait</a></h3>
            <p class="small-desc">A versatile lure for freshwater fishing.</p>
            <p>Price: $5.99</p>
            <a href="single_product.php?id=1" class="btn">View Details / Buy Now</a>
        </div>

        <div class="product">
            <a href="single_product.php?id=2">
                <img src="multi_images/lure2.jpg" alt="Crankbait">
            </a>
            <h3><a href="single_product.php?id=2">Crankbait</a></h3>
            <p class="small-desc">Ideal for covering large water areas quickly.</p>
            <p>Price: $6.99</p>
            <a href="single_product.php?id=2" class="btn">View Details / Buy Now</a>
        </div>

        <div class="product">
            <a href="single_product.php?id=3">
                <img src="multi_images/lure3.jpg" alt="Soft Plastic Worm">
            </a>
            <h3><a href="single_product.php?id=3">Soft Plastic Worm</a></h3>
            <p class="small-desc">Perfect for finesse fishing techniques.</p>
            <p>Price: $3.99</p>
            <a href="single_product.php?id=3" class="btn">View Details / Buy Now</a>
        </div>

        <div class="product">
            <a href="single_product.php?id=4">
                <img src="multi_images/lure4.jpg" alt="Jig">
            </a>
            <h3><a href="single_product.php?id=4">Jig</a></h3>
            <p class="small-desc">Works great around cover and structure.</p>
            <p>Price: $4.49</p>
            <a href="single_product.php?id=4" class="btn">View Details / Buy Now</a>
        </div>

        <div class="product">
            <a href="single_product.php?id=5">
                <img src="multi_images/lure5.jpg" alt="Topwater Frog">
            </a>
            <h3><a href="single_product.php?id=5">Topwater Frog</a></h3>
            <p class="small-desc">Exciting topwater action for bass.</p>
            <p>Price: $7.99</p>
            <a href="single_product.php?id=5" class="btn">View Details / Buy Now</a>
        </div>

        <div class="product">
            <a href="single_product.php?id=6">
                <img src="multi_images/lure6.jpg" alt="Swimbait">
            </a>
            <h3><a href="single_product.php?id=6">Swimbait</a></h3>
            <p class="small-desc">Mimics natural baitfish for larger catches.</p>
            <p>Price: $9.49</p>
            <a href="single_product.php?id=6" class="btn">View Details / Buy Now</a>
        </div>

    </div>
</main>
</body>
</html>
